package jadean.ui.handlers;

import jadean.ui.java.handlers.JavaDependencyAnalyzerHandler;

public class DependencyAnalyzerHandlersFactory {
	
	private static DependencyAnalyzerHandlersFactory _instance = null;
	private final static String JAVA_NATURE = "org.eclipse.jdt.core.javanature";
	
	private DependencyAnalyzerHandlersFactory() {
	}
	
	public static DependencyAnalyzerHandlersFactory getInstance() {
		if (_instance == null) {
			return new DependencyAnalyzerHandlersFactory();
		}
		else {
			return _instance;
		}
	}
	
	public DependencyAnalyzerHandler getHandler(String natureID) {
		if (natureID.equals(JAVA_NATURE)) {
			return new JavaDependencyAnalyzerHandler();
		}
		return new DefaultDependencyAnalyzerHandler();
	}
	
	public boolean isSupportedNature(String natureID) {
		return JAVA_NATURE.equals(natureID);
	}
}
